
#include "Noise.inc"

void GetBlocklightFalloff(inout float blocklight) {
	blocklight = rcp(sqr(16.0 - 15.0 * blocklight)) + sqr(blocklight) * 0.05;
	blocklight = remap(rcp(sqr(16.0)), 1.0, blocklight);
}

vec3 ScreenToViewSpaceRaw(in vec3 screenPos) {	
	vec3 NDCPos = screenPos * 2.0 - 1.0;
	vec4 viewPos = gbufferProjectionInverse * vec4(NDCPos, 1.0);
		 viewPos /= viewPos.w;

	return viewPos.xyz / viewPos.w;
}

vec3 ScreenToViewSpace(in vec3 screenPos) {
	vec3 NDCPos = screenPos * 2.0 - 1.0;
	#ifdef TAA_ENABLED
		NDCPos.xy -= taaOffset;
	#endif
	vec4 viewPos = gbufferProjectionInverse * vec4(NDCPos, 1.0);

	return viewPos.xyz / viewPos.w;
}

float ScreenToViewSpace(in float depth) {
    depth = depth * 2.0 - 1.0;
    return 1.0 / (depth * gbufferProjectionInverse[2][3] + gbufferProjectionInverse[3][3]);
}

vec3 ViewToScreenSpaceRaw(in vec3 viewPos) {
    vec4 clipPos = gbufferProjection * vec4(viewPos, 1.0);
    vec3 NDCPos = clipPos.xyz / clipPos.w;
    return NDCPos * 0.5 + 0.5;
}

vec3 ViewToScreenSpace(in vec3 viewPos) {
    vec4 clipPos = gbufferProjection * vec4(viewPos, 1.0);
    vec3 NDCPos = clipPos.xyz / clipPos.w;
	#ifdef TAA_ENABLED
		NDCPos.xy += taaOffset;
	#endif
    return NDCPos * 0.5 + 0.5;
}

float GetDepth(in vec2 coord) {
	return texture(depthtex1, coord).x;
}

float GetDepth(in ivec2 texel) {
	return texelFetch(depthtex1, texel, 0).x;
}

float GetDepthT(in vec2 coord) {
	float depthT = texture(depthtex0, coord).x;
	return depthT + 0.38 * step(depthT, 0.56);
}

float GetDepthT(in ivec2 texel) {
	float depthT = texelFetch(depthtex0, texel, 0).x;
	return depthT + 0.38 * step(depthT, 0.56);
}

float GetDepthLinear(in vec2 coord) {
    return (near * far) / (GetDepth(coord) * (near - far) + far);
}

float GetDepthLinear(in ivec2 texel) {
    return (near * far) / (GetDepth(texel) * (near - far) + far);
}

float GetDepthLinear(in float depth) {
    return (near * far) / (depth * (near - far) + far);
}

vec3 GetNormals(in vec2 coord) {
	return DecodeNormal(texture(colortex3, coord).xy);
}

vec3 GetNormals(in ivec2 texel) {
	return DecodeNormal(texelFetch(colortex3, texel, 0).xy);
}

const ivec2 offset3x3[9] = ivec2[9](
    ivec2(-1, -1), ivec2(0, -1), ivec2(1, -1),
    ivec2(-1,  0), ivec2(0,  0), ivec2(1,  0),
    ivec2(-1,  1), ivec2(0,  1), ivec2(1,  1)
);

const ivec2 offset3x3N[8] = ivec2[8](
    ivec2(-1, -1), ivec2(0, -1), ivec2(1, -1),
    ivec2(-1,  0), 				 ivec2(1,  0),
    ivec2(-1,  1), ivec2(0,  1), ivec2(1,  1)
);

const ivec2 offset4x4[16] = ivec2[16](
	ivec2(-2, -2), ivec2(-1, -2), ivec2(1, -2), ivec2(2, -2),
	ivec2(-2, -1), ivec2(-1, -1), ivec2(1, -1), ivec2(2, -1),
	ivec2(-2,  1), ivec2(-1,  1), ivec2(1,  1), ivec2(2,  1), 
	ivec2(-2,  2), ivec2(-1,  2), ivec2(1,  2), ivec2(2,  2)
);
/*
const ivec2 offset5x5[25] = ivec2[25](
	ivec2(-2, -2), ivec2(-1, -2), ivec2(0, -2), ivec2(1, -2), ivec2(2, -2),
	ivec2(-2, -1), ivec2(-1, -1), ivec2(0, -1), ivec2(1, -1), ivec2(2, -1),
	ivec2(-2,  0), ivec2(-1,  0), ivec2(0,  0), ivec2(1,  0), ivec2(2,  0), 
	ivec2(-2,  1), ivec2(-1,  1), ivec2(0,  1), ivec2(1,  1), ivec2(2,  1), 
	ivec2(-2,  2), ivec2(-1,  2), ivec2(0,  2), ivec2(1,  2), ivec2(2,  2)
);

const ivec2 offset7x7[49] = ivec2[49](
	ivec2(-3, -3), ivec2(-2, -3), ivec2(-1, -3), ivec2(0, -3), ivec2(1, -3), ivec2(2, -3), ivec2(3, -3),
	ivec2(-3, -2), ivec2(-2, -2), ivec2(-1, -2), ivec2(0, -2), ivec2(1, -2), ivec2(2, -2), ivec2(3, -2),
	ivec2(-3, -1), ivec2(-2, -1), ivec2(-1, -1), ivec2(0, -1), ivec2(1, -1), ivec2(2, -1), ivec2(3, -1),
	ivec2(-3,  0), ivec2(-2,  0), ivec2(-1,  0), ivec2(0,  0), ivec2(1,  0), ivec2(2,  0), ivec2(3,  0),
	ivec2(-3,  1), ivec2(-2,  1), ivec2(-1,  1), ivec2(0,  1), ivec2(1,  1), ivec2(2,  1), ivec2(3,  1),
	ivec2(-3,  2), ivec2(-2,  2), ivec2(-1,  2), ivec2(0,  2), ivec2(1,  2), ivec2(2,  2), ivec2(3,  2),
	ivec2(-3,  3), ivec2(-2,  3), ivec2(-1,  3), ivec2(0,  3), ivec2(1,  3), ivec2(2,  3), ivec2(3,  3)
);
*/
vec4 GetCausticsTexDeferred(in vec2 coord) {
	vec2 lookupCoord = vec2(coord.x, (coord.y - floor(fract(frameTimeCounter * WATER_WAVE_SPEED) * 60.0)) * rcp(60.0));
	return texture(depthtex2, lookupCoord);
}

float GetCaustics(in vec3 worldPos, in float waterDepth) {
	vec3 causticPos = worldPos + cameraPosition;
	vec3 refractLightVector = refract(worldLightVector, vec3(0.0, 1.0, 0.0), 1.0 / WATER_REFRACT_IOR);
	causticPos += refractLightVector * causticPos.y / refractLightVector.y;

	vec4 causticsTex = GetCausticsTexDeferred(fract(causticPos.xz * 0.5));

	float depthBlend = sqrt(waterDepth * 0.5);

	float caustics = pow(causticsTex.r, saturate(depthBlend * 0.5 + 0.5));
	caustics = mix(caustics, causticsTex.g, saturate(depthBlend - 1.0));
	caustics = mix(caustics, causticsTex.b, saturate(depthBlend - 2.0));
	caustics = mix(caustics, causticsTex.a, saturate(depthBlend - 3.0));

	return caustics * 10.0;
}
